/*
 * Copyright (C) 2019 Alexandros Theodotou <alex at zrythm dot org>
 *
 * This file is part of Zrythm
 *
 * Zrythm is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Zrythm is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with Zrythm.  If not, see <https://www.gnu.org/licenses/>.
 */

/**
 * \mainpage Documentation
 *
 * \section introduction Introduction
 *
 * This documentation is aimed at developers wishing
 * to study the source code or contribute to Zrythm.
 * This is a general outline of how Zrythm works, and
 * more detailed information can be found by looking
 * at each tab above.
 *
 * A good starting point would be to check the
 * Modules above
 *
 * The main structs to look at would be Project
 * and Zrythm (inc/project.h and inc/zrythm.h)
 *
 * \section contributing Contributing
 *
 * If you would like to contribute please review
 * the \ref md_CONTRIBUTING
 *
 * \section pages Pages
 * - \subpage processing_cycle
 * - \subpage cyaml_schemas
 * - \subpage release_checklist
 * - \subpage weblate
 */
