#! /bin/sh
# check script for Zutils - Utilities dealing with compressed files
# Copyright (C) 2009, 2010, 2011, 2012, 2013 Antonio Diaz Diaz.
#
# This script is free software: you have unlimited permission
# to copy, distribute and modify it.

LC_ALL=C
export LC_ALL
objdir=`pwd`
testdir=`cd "$1" ; pwd`
ZCAT="${objdir}"/zcat
ZCMP="${objdir}"/zcmp
ZDIFF="${objdir}"/zdiff
ZGREP="${objdir}"/zgrep
ZEGREP="${objdir}"/zegrep
ZFGREP="${objdir}"/zfgrep
ZTEST="${objdir}"/ztest
compressors="bzip2 gzip lzip"
extensions="bz2 gz lz"
compressor_needed() { echo "${compressors} are needed to run tests" ; exit 1 ; }
framework_failure() { echo "failure in testing framework" ; exit 1 ; }

if [ ! -x "${ZCAT}" ] ; then
	echo "${ZCAT}: cannot execute"
	exit 1
fi

if [ -d tmp ] ; then rm -rf tmp ; fi
mkdir tmp
cd "${objdir}"/tmp

for i in ${compressors}; do
	cat "${testdir}"/test.txt > in || framework_failure
	$i in || compressor_needed
done

cat "${testdir}"/test.txt > in || framework_failure
cat "${testdir}"/test.txt.tar > in.tar || framework_failure
printf "01234567890" > pin.tar || framework_failure
cat in.tar in.tar in.tar in.tar >> pin.tar || framework_failure
cat in > -in- || framework_failure
cat in.lz > -in-.lz || framework_failure
cat in.lz > lz_only.lz || framework_failure
cat in in in in in in > in6 || framework_failure
fail=0

printf "testing zutils-%s..." "$2"

printf "\ntesting   zcat-%s..." "$2"

for i in ${extensions}; do
	"${ZCAT}" in.$i > copy || fail=1
	cmp in copy || fail=1
	printf .
	"${ZCAT}" --format=$i in.$i > copy || fail=1
	cmp in copy || fail=1
	printf .
	"${ZCAT}" in.$i | dd bs=1000 count=1 > copy 2> /dev/null || fail=1
	dd if=in bs=1000 count=1 2> /dev/null | cmp - copy || fail=1
	printf .
done

"${ZCAT}" < in > copy || fail=1
cmp in copy || fail=1
printf .
"${ZCAT}" < in.gz > copy || fail=1
cmp in copy || fail=1
printf .
"${ZCAT}" < in.bz2 > copy || fail=1
cmp in copy || fail=1
printf .
"${ZCAT}" < in.lz > copy || fail=1
cmp in copy || fail=1
printf .
"${ZCAT}" in > copy || fail=1
cmp in copy || fail=1
printf .
"${ZCAT}" lz_only > copy || fail=1
cmp in copy || fail=1
printf .
"${ZCAT}" in in.gz in.bz2 in.lz -- -in- -in-.lz > copy6 || fail=1
cmp in6 copy6 || fail=1
printf .
"${ZCAT}" --format=gz in.bz2 2> /dev/null
if [ $? = 1 ] ; then printf . ; else printf - ; fail=1 ; fi
"${ZCAT}" --format=bz2 in.lz 2> /dev/null
if [ $? = 1 ] ; then printf . ; else printf - ; fail=1 ; fi
"${ZCAT}" --format=lz in.gz 2> /dev/null
if [ $? = 1 ] ; then printf . ; else printf - ; fail=1 ; fi
"${ZCAT}" --bad-option 2> /dev/null
if [ $? = 1 ] ; then printf . ; else printf - ; fail=1 ; fi


printf "\ntesting   zcmp-%s..." "$2"

for i in ${extensions}; do
	"${ZCMP}" in.$i || fail=1
	printf .
	"${ZCMP}" in in.$i || fail=1
	printf .
	"${ZCMP}" -i 100 -n 500 in6 in.$i || fail=1
	printf .
	"${ZCMP}" in in.$i --format=,$i || fail=1
	printf .
	"${ZCMP}" in.$i in || fail=1
	printf .
	"${ZCMP}" -i 1000:1000 -n 50 in.$i in6 || fail=1
	printf .
	"${ZCMP}" in.$i in --format=$i || fail=1
	printf .
done

"${ZCMP}" in in6 2> /dev/null
if [ $? = 1 ] ; then printf . ; else printf - ; fail=1 ; fi
"${ZCMP}" -n 0 in in6 || fail=1
"${ZCMP}" -n 100 in in6 || fail=1
"${ZCMP}" -n 1000 in in6 || fail=1
"${ZCMP}" -n 10000 in in6 || fail=1
printf .
"${ZCMP}" in.tar pin.tar > /dev/null
if [ $? = 1 ] ; then printf . ; else printf - ; fail=1 ; fi
"${ZCMP}" -i 0,11 in.tar pin.tar 2> /dev/null
if [ $? = 1 ] ; then printf . ; else printf - ; fail=1 ; fi
"${ZCMP}" -i 0,11 -n 0 in.tar pin.tar || fail=1
"${ZCMP}" -i 0,11 -n 100 in.tar pin.tar || fail=1
"${ZCMP}" -i 0,11 -n 1000 in.tar pin.tar || fail=1
"${ZCMP}" -i 0,11 -n 10000 in.tar pin.tar || fail=1
printf .
"${ZCMP}" - || fail=1
printf .
"${ZCMP}" in in || fail=1
printf .
"${ZCMP}" in || fail=1
printf .
"${ZCMP}" in.lz in.gz || fail=1
printf .
"${ZCMP}" in.gz -- -in-.lz || fail=1
printf .
"${ZCMP}" -- -in-.lz in.gz || fail=1
printf .
"${ZCMP}" in -- -in-.lz || fail=1
printf .
"${ZCMP}" -- -in- in.lz || fail=1
printf .
"${ZCMP}" in.lz -- -in- || fail=1
printf .
"${ZCMP}" -- -in-.lz in || fail=1
printf .
"${ZCMP}" -- -in- in || fail=1
printf .
"${ZCMP}" in -- -in- || fail=1
printf .
"${ZCMP}" lz_only.lz < in || fail=1
printf .
"${ZCMP}" in.lz - < in || fail=1
printf .
"${ZCMP}" - in.lz < in || fail=1
printf .
"${ZCMP}" in - < in.lz || fail=1
printf .
"${ZCMP}" - in < in.lz || fail=1
printf .
"${ZCMP}" -q --format=lz in.lz
if [ $? = 2 ] ; then printf . ; else printf - ; fail=1 ; fi
"${ZCMP}" --format=lz in.gz in.lz 2> /dev/null
if [ $? = 2 ] ; then printf . ; else printf - ; fail=1 ; fi
"${ZCMP}" -n -1 in in 2> /dev/null
if [ $? = 2 ] ; then printf . ; else printf - ; fail=1 ; fi
"${ZCMP}" --bad-option in in 2> /dev/null
if [ $? = 2 ] ; then printf . ; else printf - ; fail=1 ; fi


printf "\ntesting  zdiff-%s..." "$2"

for i in ${extensions}; do
	"${ZDIFF}" in.$i || fail=1
	printf .
	"${ZDIFF}" in in.$i || fail=1
	printf .
	"${ZDIFF}" --format=,$i in in.$i || fail=1
	printf .
	"${ZDIFF}" in.$i in || fail=1
	printf .
	"${ZDIFF}" --format=$i, in.$i in || fail=1
	printf .
done

"${ZDIFF}" in in6 > /dev/null
if [ $? != 0 ] ; then printf . ; else printf - ; fail=1 ; fi
"${ZDIFF}" in.tar pin.tar > /dev/null
if [ $? != 0 ] ; then printf . ; else printf - ; fail=1 ; fi
"${ZDIFF}" - || fail=1
printf .
"${ZDIFF}" in in || fail=1
printf .
"${ZDIFF}" in || fail=1
printf .
"${ZDIFF}" in.lz in.gz || fail=1
printf .
"${ZDIFF}" in.gz -- -in-.lz || fail=1
printf .
"${ZDIFF}" -- -in-.lz in.gz || fail=1
printf .
"${ZDIFF}" in -- -in-.lz || fail=1
printf .
"${ZDIFF}" -- -in- in.lz || fail=1
printf .
"${ZDIFF}" in.lz -- -in- || fail=1
printf .
"${ZDIFF}" -- -in-.lz in || fail=1
printf .
"${ZDIFF}" -- -in- in || fail=1
printf .
"${ZDIFF}" in -- -in- || fail=1
printf .
"${ZDIFF}" lz_only.lz < in || fail=1
printf .
"${ZDIFF}" in.lz - < in || fail=1
printf .
"${ZDIFF}" - in.lz < in || fail=1
printf .
"${ZDIFF}" in - < in.lz || fail=1
printf .
"${ZDIFF}" - in < in.lz || fail=1
printf .
"${ZDIFF}" -q --format=bz2 in.bz2 2> /dev/null
if [ $? = 2 ] ; then printf . ; else printf - ; fail=1 ; fi
"${ZDIFF}" -q --format=,lz in.lz in.bz2 > /dev/null 2> /dev/null
if [ $? = 2 ] ; then printf . ; else printf - ; fail=1 ; fi
"${ZDIFF}" --bad-option 2> /dev/null
if [ $? = 2 ] ; then printf . ; else printf - ; fail=1 ; fi


printf "\ntesting  zgrep-%s..." "$2"

for i in ${extensions}; do
	"${ZGREP}" "GNU" in.$i > /dev/null || fail=1
	printf .
	"${ZGREP}" -l "GNU" in.$i > /dev/null || fail=1
	printf .
	"${ZGREP}" -L "GNU" in.$i || fail=1
	printf .
	"${ZGREP}" --format=$i "GNU" in.$i > /dev/null || fail=1
	printf .
	"${ZGREP}" -v "nx_pattern" in.$i > /dev/null || fail=1
	printf .
	"${ZGREP}" "nx_pattern" in.$i
	if [ $? != 0 ] ; then printf . ; else printf - ; fail=1 ; fi
	"${ZGREP}" -l "nx_pattern" in.$i
	if [ $? != 0 ] ; then printf . ; else printf - ; fail=1 ; fi
	"${ZGREP}" -L "nx_pattern" in.$i > /dev/null
	if [ $? != 0 ] ; then printf . ; else printf - ; fail=1 ; fi
	"${ZGREP}" --format=$i "GNU" in 2> /dev/null
	if [ $? = 2 ] ; then printf . ; else printf - ; fail=1 ; fi
done

"${ZGREP}" "GNU" < pin.tar > /dev/null || fail=1
printf .
"${ZGREP}" "GNU" pin.tar > /dev/null || fail=1
printf .
"${ZGREP}" -r "GNU" . > /dev/null || fail=1
printf .
"${ZGREP}" "nx_pattern" -r . in > /dev/null
if [ $? != 0 ] ; then printf . ; else printf - ; fail=1 ; fi
"${ZGREP}" "GNU" < in > /dev/null || fail=1
printf .
"${ZGREP}" "GNU" < in.gz > /dev/null || fail=1
printf .
"${ZGREP}" "GNU" < in.bz2 > /dev/null || fail=1
printf .
"${ZGREP}" "GNU" < in.lz > /dev/null || fail=1
printf .
"${ZGREP}" "GNU" in > /dev/null || fail=1
printf .
"${ZGREP}" "GNU" -- -in- > /dev/null || fail=1
printf .
"${ZGREP}" "GNU" -- -in-.lz > /dev/null || fail=1
printf .
"${ZGREP}" "GNU" in in.gz in.bz2 in.lz -- -in- > /dev/null || fail=1
printf .
"${ZGREP}" -l "GNU" in in.gz in.bz2 in.lz -- -in- > /dev/null || fail=1
printf .
"${ZGREP}" -L "GNU" in in.gz in.bz2 in.lz -- -in- || fail=1
printf .
"${ZGREP}" -l "nx_pattern" in in.gz in.bz2 in.lz -- -in-
if [ $? != 0 ] ; then printf . ; else printf - ; fail=1 ; fi
"${ZGREP}" -L "nx_pattern" in in.gz in.bz2 in.lz -- -in- > /dev/null
if [ $? != 0 ] ; then printf . ; else printf - ; fail=1 ; fi
"${ZGREP}" --bad-option 2> /dev/null
if [ $? = 2 ] ; then printf . ; else printf - ; fail=1 ; fi

"${ZEGREP}" "GNU" in > /dev/null || fail=1
printf .
"${ZFGREP}" "GNU" in > /dev/null || fail=1
printf .


printf "\ntesting  ztest-%s..." "$2"

for i in ${extensions}; do
	"${ZTEST}" --format=$i < in.$i || fail=1
	printf .
	"${ZTEST}" --format=$i < in 2> /dev/null
	if [ $? = 2 ] ; then printf . ; else printf - ; fail=1 ; fi
	"${ZTEST}" --format=$i in 2> /dev/null
	if [ $? = 2 ] ; then printf . ; else printf - ; fail=1 ; fi
done

"${ZTEST}" in in.gz in.bz2 in.lz -- -in- || fail=1
printf .
"${ZTEST}" < in.gz || fail=1
printf .
"${ZTEST}" < in.bz2 || fail=1
printf .
"${ZTEST}" < in.lz || fail=1
printf .
"${ZTEST}" -r . || fail=1
printf .
"${ZTEST}" < in 2> /dev/null
if [ $? = 2 ] ; then printf . ; else printf - ; fail=1 ; fi
dd if=in.lz bs=1000 count=1 2> /dev/null | "${ZTEST}" -q
if [ $? = 2 ] ; then printf . ; else printf - ; fail=1 ; fi
"${ZTEST}" --format=lz in.bz2 2> /dev/null
if [ $? = 2 ] ; then printf . ; else printf - ; fail=1 ; fi
"${ZTEST}" --bad-option 2> /dev/null
if [ $? = 1 ] ; then printf . ; else printf - ; fail=1 ; fi

echo
if [ ${fail} = 0 ] ; then
	echo "tests completed successfully."
	cd "${objdir}" && rm -r tmp
else
	echo "tests failed."
fi
exit ${fail}
